# Improving group robustness under noisy labels using predictive uncertainty

## Abstract

> Standard empirical risk minimization (ERM) commonly underperforms on certain minority groups due to spurious-cue between the input and its label. Several studies, such as group distributionally robust optimization and JTT, have improved the worst-group accuracy by focusing on training high-loss samples. The hypothesis behind this is that such samples do not have spurious-cue. However, these approaches can be problematic since the high-loss samples can also be the samples with noisy labels in the real-world scenario. In this paper, we facilitate improving worst-group accuracy under the noisy labels by redefining spurious-cue-free (SCF) samples with the predictive uncertainty of the model. To achieve this, we aim to train the identification model to mine SCF samples using its predictive uncertainty. Our main idea for the identification model is two folds: (1) we use entropy regularization to increase uncertainty for the minority groups (2) and utilize non-exponential loss--MAE loss--robust to noisy labels. By doing so, the identification model assigns high uncertainty to the minority groups (SCF samples), but not to noisy labels.

## Motivation (Informal)

- **(Problem 1: Spurious cue)** The poor test accuracy is often caused by the fact that the model could focus on the **spurious cue** of the training set. [[Wiles 2021]](https://arxiv.org/abs/2110.11328)
- **(Problem 2: Noisy labels)** The label noise can be problematic, especially on real-world datasets which involve observation noise such as biology, and chemistry domain data.
- **(Goal and benefit)** The robust model for both **spurious cue** and **label noise**

## Demo

### Quick start

Example scripts are in "./scripts/\*".
