import torch
import torch.nn as nn
import torch.nn.functional as F


class Model(nn.Module):
    def __init__(self):
        super(Model, self).__init__()
        self.layers = nn.Sequential(
            nn.Linear(2, 200),
            nn.ReLU(),
            nn.Linear(200, 50),
            nn.ReLU(),
            nn.Linear(50, 50),
            nn.ReLU(),
            nn.Linear(50, 1),
        )

    def __call__(self, x):
        return self.layers(x)


class ClassificationToyModel(nn.Module):
    def __init__(self):
        super(ClassificationToyModel, self).__init__()
        self.layers = nn.Sequential(
            nn.Linear(2, 200),
            nn.ReLU(),
            nn.Linear(200, 50),
            nn.ReLU(),
            nn.Linear(50, 50),
            nn.ReLU(),
            nn.Linear(50, 50),
            nn.ReLU(),
            nn.Linear(50, 50),
            nn.ReLU(),
            nn.Linear(50, 2),
        )

    def __call__(self, x):
        return self.layers(x)


class ClassificationToyModelBN(nn.Module):
    def __init__(self, dim=2):
        super(ClassificationToyModelBN, self).__init__()
        self.layers = nn.Sequential(
            nn.Linear(dim, 4096),
            nn.BatchNorm1d(4096),
            nn.LeakyReLU(),
            nn.Linear(4096, 2)
        )

    def __call__(self, x):
        return self.layers(x)


"""
class ClassificationToyModelBN(nn.Module):
    def __init__(self):
        super(ClassificationToyModelBN, self).__init__()
        self.layers = nn.Sequential(
            nn.Linear(2, 200),
            # nn.BatchNorm1d(1024),
            nn.ReLU(),
            nn.Linear(200, 50),
            # nn.BatchNorm1d(512),
            nn.ReLU(),
            nn.Linear(50, 50),
            # nn.BatchNorm1d(256),
            nn.ReLU(),
            nn.Linear(50, 50),
            # nn.BatchNorm1d(128),
            nn.ReLU(),
            nn.Linear(50, 50),
            # nn.BatchNorm1d(64),
            nn.ReLU(),
            nn.Linear(50, 2),
        )

    def __call__(self, x):
        return self.layers(x)
nn.BatchNorm1d(50),
            nn.ReLU(),
            nn.Linear(50, 50),
            nn.BatchNorm1d(50),
            nn.ReLU(),
            nn.Linear(50, 50),
            nn.BatchNorm1d(50),
            nn.ReLU(),
            nn.Linear(50, 50),
            nn.BatchNorm1d(50),
            nn.ReLU(),
            nn.Linear(50, 2),
        
"""


class UCIModel(nn.Module):
    def __init__(self, input_dim, output_dim=1):
        super(UCIModel, self).__init__()
        self.layers = nn.Sequential(
            nn.Linear(input_dim, 256),
            nn.ReLU(),
            nn.Linear(256, 256),
            nn.ReLU(),
            nn.Linear(256, 256),
            nn.ReLU(),
            nn.Linear(256, 256),
            nn.ReLU(),
            nn.Linear(256, output_dim))

    def __call__(self, x):
        return self.layers(x)
