import torch
import torch.nn as nn
import torch.nn.functional as F


class Model(nn.Module):
    def __init__(self):
        super(Model, self).__init__()
        self.layers = nn.Sequential(
            nn.Linear(2, 200),
            nn.GELU(),
            nn.Linear(200, 50),
            nn.GELU(),
            nn.Linear(50, 50),
            nn.GELU(),
            nn.Linear(50, 1),
        )

    def __call__(self, x):
        return self.layers(x)


class ClassificationToyModel(nn.Module):
    def __init__(self):
        super(ClassificationToyModel, self).__init__()
        self.layers = nn.Sequential(
            nn.Linear(2, 200),
            nn.GELU(),
            nn.Linear(200, 50),
            nn.GELU(),
            nn.Linear(50, 50),
            nn.GELU(),
            nn.Linear(50, 50),
            nn.GELU(),
            nn.Linear(50, 50),
            nn.GELU(),
            nn.Linear(50, 2),
        )

    def __call__(self, x):
        return self.layers(x)


"""
class ClassificationToyModelBN(nn.Module):
    def __init__(self, dim=2):
        super(ClassificationToyModelBN, self).__init__()
        self.layers = nn.Sequential(
            nn.Linear(dim, 200),
            nn.GELU(),
            nn.Linear(200, 50),
            # nn.BatchNorm1d(50),
            nn.GELU(),
            nn.Linear(50, 50),
            # nn.BatchNorm1d(50),
            nn.GELU(),
            nn.Linear(50, 2),
        )

    def __call__(self, x):
        return self.layers(x)
"""


class ClassificationToyModelBN(nn.Module):
    def __init__(self, dim=2):
        super(ClassificationToyModelBN, self).__init__()
        self.layers = nn.Sequential(
            nn.Linear(dim, 50000),
            nn.ReLU(),
            nn.Linear(50000, 2),
        )

    def __call__(self, x):
        return self.layers(x)


class ClassificationToyModelOP(nn.Module):
    def __init__(self, dim=2):
        super(ClassificationToyModelOP, self).__init__()
        self.layers = nn.Sequential(
            nn.Linear(dim, 5000),
            nn.ReLU(),
            nn.Linear(5000, 5000),
            nn.ReLU(),
            nn.Linear(5000, 5000),
            nn.ReLU(),
            nn.Linear(5000, 2),
        )

    def __call__(self, x):
        return self.layers(x)


"""
class ClassificationToyModelBN(nn.Module):
    def __init__(self):
        super(ClassificationToyModelBN, self).__init__()



class ClassificationToyModelBN(nn.Module):
    def __init__(self):
        super(ClassificationToyModelBN, self).__init__()
        self.layers = nn.Sequential(
            nn.Linear(2, 200),
            # nn.BatchNorm1d(1024),
            nn.GELU(),
            nn.Linear(200, 50),
            # nn.BatchNorm1d(512),
            nn.GELU(),
            nn.Linear(50, 50),
            # nn.BatchNorm1d(256),
            nn.GELU(),
            nn.Linear(50, 50),
            # nn.BatchNorm1d(128),
            nn.GELU(),
            nn.Linear(50, 50),
            # nn.BatchNorm1d(64),
            nn.GELU(),
            nn.Linear(50, 2),
        )

    def __call__(self, x):
        return self.layers(x)

"""
