seed_no='1'
workdir='results_gamma/waterbirds_exp/seed_1'
ent_reg='0.3'
device_id='0'
mkdir -p ${workdir}/0.0_noise/END
mkdir -p ${workdir}/0.0_noise/ERM
mkdir -p ${workdir}/0.1_noise/END
mkdir -p ${workdir}/0.1_noise/ERM
mkdir -p ${workdir}/0.2_noise/END
mkdir -p ${workdir}/0.2_noise/ERM
mkdir -p ${workdir}/0.3_noise/END
mkdir -p ${workdir}/0.3_noise/ERM

# without easy sample learning, lr should be 1e-3, epoch = 50
nohup python -u train_id_model.py --warmup 0 --device_id ${device_id} --seed ${seed_no} --lr 1e-3 --save_epochs 5 --epochs 50 --data_type waterbirds --l2 1e-4 --batch-size 64 --dir ${workdir}/0.0_noise --ent_reg ${ent_reg} --p_noise 0.0 > ${workdir}/0.0_noise/make_hard.log &
nohup python -u train_id_model.py --warmup 0 --device_id ${device_id} --seed ${seed_no} --lr 1e-3 --save_epochs 5 --epochs 50 --data_type waterbirds --l2 1e-4 --batch-size 64 --dir ${workdir}/0.1_noise --ent_reg ${ent_reg} --p_noise 0.1 > ${workdir}/0.1_noise/make_hard.log &
nohup python -u train_id_model.py --warmup 0 --device_id ${device_id} --seed ${seed_no} --lr 1e-3 --save_epochs 5 --epochs 50 --data_type waterbirds --l2 1e-4 --batch-size 64 --dir ${workdir}/0.2_noise --ent_reg ${ent_reg} --p_noise 0.2 > ${workdir}/0.2_noise/make_hard.log &
nohup python -u train_id_model.py --warmup 0 --device_id ${device_id} --seed ${seed_no} --lr 1e-3 --save_epochs 5 --epochs 50 --data_type waterbirds --l2 1e-4 --batch-size 64 --dir ${workdir}/0.3_noise --ent_reg ${ent_reg} --p_noise 0.3 > ${workdir}/0.3_noise/make_hard.log &
wait

nohup python -u train_erm.py --device_id ${device_id} --seed ${seed_no} --p_h 100 --lr 1e-5 --epochs 300 --data_type waterbirds --dir ${workdir}/0.0_noise/END --curricular --l2 1 --batch-size 64 --idx ${workdir}/0.0_noise/uncertain_idx.pk  > ${workdir}/0.0_noise/END/train.log &
#nohup python -u train_erm.py --device_id ${device_id} --seed ${seed_no} --lr 1e-3 --epochs 300 --data_type waterbirds --dir ${workdir}/0.0_noise/ERM --l2 1e-4 --batch-size 64  > ${workdir}/0.0_noise/ERM/train.log &
nohup python -u train_erm.py --device_id ${device_id} --seed ${seed_no} --data_file ${workdir}/0.1_noise/noisy_data.pk --p_h 100 --lr 1e-5 --epochs 300 --data_type waterbirds --dir ${workdir}/0.1_noise/END --curricular --l2 1 --batch-size 64 --idx ${workdir}/0.1_noise/uncertain_idx.pk  > ${workdir}/0.1_noise/END/train.log &
#nohup python -u train_erm.py --device_id ${device_id} --seed ${seed_no} --data_file ${workdir}/0.1_noise/noisy_data.pk --lr 1e-3 --epochs 300 --data_type waterbirds --dir ${workdir}/0.1_noise/ERM --l2 1e-4 --batch-size 64  > ${workdir}/0.1_noise/ERM/train.log &
nohup python -u train_erm.py --device_id ${device_id} --seed ${seed_no} --data_file ${workdir}/0.2_noise/noisy_data.pk --p_h 100 --lr 1e-5 --epochs 300 --data_type waterbirds --dir ${workdir}/0.2_noise/END --curricular --l2 1 --batch-size 64 --idx ${workdir}/0.2_noise/uncertain_idx.pk  > ${workdir}/0.2_noise/END/train.log &
#nohup python -u train_erm.py --device_id ${device_id} --seed ${seed_no} --data_file ${workdir}/0.2_noise/noisy_data.pk --lr 1e-3 --epochs 300 --data_type waterbirds --dir ${workdir}/0.2_noise/ERM --l2 1e-4 --batch-size 64  > ${workdir}/0.2_noise/ERM/train.log &
nohup python -u train_erm.py --device_id ${device_id} --seed ${seed_no} --data_file ${workdir}/0.3_noise/noisy_data.pk --p_h 100 --lr 1e-5 --epochs 300 --data_type waterbirds --dir ${workdir}/0.3_noise/END --curricular --l2 1 --batch-size 64 --idx ${workdir}/0.3_noise/uncertain_idx.pk  > ${workdir}/0.3_noise/END/train.log &
#nohup python -u train_erm.py --device_id ${device_id} --seed ${seed_no} --data_file ${workdir}/0.3_noise/noisy_data.pk --lr 1e-3 --epochs 300 --data_type waterbirds --dir ${workdir}/0.3_noise/ERM --l2 1e-4 --batch-size 64  > ${workdir}/0.3_noise/ERM/train.log &
wait

nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --best --n_model 1 --data_type waterbirds --dir ${workdir}/0.0_noise/END --batch-size 64 > ${workdir}/0.0_noise/END/eval.log &
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --best --n_model 1 --data_type waterbirds --dir ${workdir}/0.0_noise/ERM --batch-size 64 > ${workdir}/0.0_noise/ERM/eval.log &
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --bestwo --n_model 1 --data_type waterbirds --dir ${workdir}/0.0_noise/END --batch-size 64 > ${workdir}/0.0_noise/END/eval_wo.log &
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --bestwo --n_model 1 --data_type waterbirds --dir ${workdir}/0.0_noise/ERM --batch-size 64 > ${workdir}/0.0_noise/ERM/eval_wo.log &
wait
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --best --n_model 1 --data_type waterbirds --dir ${workdir}/0.1_noise/END --batch-size 64 > ${workdir}/0.1_noise/END/eval.log &
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --best --n_model 1 --data_type waterbirds --dir ${workdir}/0.1_noise/ERM --batch-size 64 > ${workdir}/0.1_noise/ERM/eval.log &
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --bestwo --n_model 1 --data_type waterbirds --dir ${workdir}/0.1_noise/END --batch-size 64 > ${workdir}/0.1_noise/END/eval_wo.log &
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --bestwo --n_model 1 --data_type waterbirds --dir ${workdir}/0.1_noise/ERM --batch-size 64 > ${workdir}/0.1_noise/ERM/eval_wo.log &
wait
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --best --n_model 1 --data_type waterbirds --dir ${workdir}/0.2_noise/END --batch-size 64 > ${workdir}/0.2_noise/END/eval.log &
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --best --n_model 1 --data_type waterbirds --dir ${workdir}/0.2_noise/ERM --batch-size 64 > ${workdir}/0.2_noise/ERM/eval.log &
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --bestwo --n_model 1 --data_type waterbirds --dir ${workdir}/0.2_noise/END --batch-size 64 > ${workdir}/0.2_noise/END/eval_wo.log &
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --bestwo --n_model 1 --data_type waterbirds --dir ${workdir}/0.2_noise/ERM --batch-size 64 > ${workdir}/0.2_noise/ERM/eval_wo.log &
wait
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --best --n_model 1 --data_type waterbirds --dir ${workdir}/0.3_noise/END --batch-size 64 > ${workdir}/0.3_noise/END/eval.log &
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --best --n_model 1 --data_type waterbirds --dir ${workdir}/0.3_noise/ERM --batch-size 64 > ${workdir}/0.3_noise/ERM/eval.log &
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --bestwo --n_model 1 --data_type waterbirds --dir ${workdir}/0.3_noise/END --batch-size 64 > ${workdir}/0.3_noise/END/eval_wo.log &
nohup python -u eval.py --device_id ${device_id} --seed ${seed_no} --bestwo --n_model 1 --data_type waterbirds --dir ${workdir}/0.3_noise/ERM --batch-size 64 > ${workdir}/0.3_noise/ERM/eval_wo.log &
wait
