import numpy as np
import scipy.stats

def confidence_interval(mu, std, confidence=0.9):
    h = std * scipy.stats.norm.ppf((1 + confidence) / 2)
    low_interval = mu - h
    up_interval = mu + h
    return mu, low_interval, up_interval

def mean_confidence_interval(data, confidence=0.95):
    a = 1.0 * np.array(data)
    n = len(a)
    m, se = np.mean(a, axis=0), scipy.stats.sem(a, axis=0)
    h = se * scipy.stats.t.ppf((1 + confidence) / 2., n-1)
    return m, m-h, m+h

def get_hard_index(model, criterion, p=0.1):
    trainloader_ordered, _ = dataset.get_loader(args, shuffle_train=False) 
    model.eval()
    score_list = []
    with torch.no_grad():
        for batch_idx, (inputs, targets, metadata) in enumerate(trainloader_ordered):
            if use_cuda:
                inputs, targets = inputs.cuda(device_id), targets.cuda(device_id)
            outputs = model(inputs)
            loss = criterion(outputs, targets)
            score_list.append(loss.cpu().numpy())
    score_list = np.concatenate(score_list)
    score_dict = dict(zip(range(len(score_list)), score_list))
    large_index = heapq.nlargest(int(len(score_list)*p), score_dict, key=scire_dict.get) #* get top k proportion from score_dict
    return large_index