out_dir = "/path/to/output/directory/"
screen_out_dir = "/path/to/screen/output/directory/"

#get_tv_options = ["join_linear","co_train","ours"]
get_tv_options = ["ours"]
tv_strength_list = [i * 0.025 for i in range(0, 161)]

#random_nums = [0,1,2,3,4]
random_nums = [0, 1, 2]
clip_sim_thss = [0.7, 0.9]

i = 0

for k, random_num in enumerate(random_nums):
    for j, tv_strength in enumerate(tv_strength_list):
        for l, get_tv_option in enumerate(get_tv_options):
            for n, clip_sim_ths in enumerate(clip_sim_thss):
                shell_script = """
cd /path/to/semi_pipeline/
python calc_2_concepts_tradeoff.py --get_tv_option {} --edit_alpha {} --clip_sim_ths {} --wandb_name {}_get_tv_option_{}_tv_strength_{:.2f}_clip_sim_ths_{:.2f}
                """.format(get_tv_option, tv_strength, clip_sim_ths, random_num, get_tv_option, tv_strength, clip_sim_ths)
                with open(out_dir + "{}.sh".format(i), "w") as file:
                    file.write(shell_script)
                i = i + 1

job_master = """#!/bin/bash
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=2
#SBATCH --gres=gpu:1
#SBATCH --time=6:59:00
#SBATCH --mem=100GB
#SBATCH --job-name=tv_int_eval
#SBATCH --mail-type=ALL
#SBATCH --mail-user=email@example.com
#SBATCH --output=/path/to/logs/tv_comb_%j.out

module purge
module load anaconda3/2020.07;
export OMP_NUM_THREADS=2;
source /path/to/anaconda3/etc/profile.d/conda.sh;
conda activate /path/to/conda_env/tv_interactions_2;
export PATH=/path/to/conda_env/tv_interactions_2/bin:$PATH;

sh $SLURM_ARRAY_TASK_ID.sh
"""
master_file_name = "run-jobarray.s"
with open(out_dir + master_file_name, "w") as file:
    file.write(job_master)

print("sbatch --array=0-{}%80 {}".format(i - 1, master_file_name))
