# RoboEXP: Action-Conditioned Scene Graph via Interactive Exploration for Robotic Manipulation

### Overview
This repository contains the official implementation of the **RoboEXP** system for the **interactive exploration** task.

### Setup
```
# Here we use cuda-11.7
export CUDA_HOME=/usr/local/cuda-11.7/
# create conda environment
conda create -n roboexp python=3.8
conda activate roboexp

# Install the packages
bash scripts/install_env.sh

# download pretrained models
bash scripts/download_pretrained_models.sh
```

### Interactive Exploration
To run our RoboEXP system, you also need to create the file `my_apikey` and copy your OpenAI API key into the file.

To calibrate the wrist camera, we provide the hand-eye calibration code in `calibrate_wrist.py`, and you can download our calibration board.
```
# Download the calibration board
gdown 1KWYncDGjtGthePC3wzCu9zBW0nZI0RBM
# Download the example calibration result
gdown 1b2yp45eJVyXnOg11OImTER3zMRUcaZRN
```

Run our RoboEXP system
```
# Set `visualize=True` to enable visualizations
python interactive_explore.py 
```

### Code Structure Explanation
`roboexp`  is the main library for our RoboEXP system, comprising the following key components:
* `roboexp/env`: This component provides the basic control API for the robot, camera, and calibration setup. It facilitates obtaining observations from the camera and controlling the robot.
* `roboexp/perception`: This component offers an API for the perception module, enabling image processing to derive 2D semantic information from images.
* `roboexp/memory`: This component provides an API for the memory module, allowing instance merging in 3D and the construction of our Action-Conditioned Scene Graph (ACSG).
* `roboexp/decision`: This component offers an API for the decision module, facilitating decision-making based on observations.
* `roboexp/act`: This component provides an API for the action module, enabling action planning based on decisions and our memory.
