# %%
import pandas as pd
# df = pd.read_csv("data/validated_dev_mistral_v2.csv")
df = pd.read_csv("asset.spider.dev.20250720.validated.csv")

# %%
df["LLMValidation"].value_counts()
# %%
df["LLMExplanation"] = df["LLMExplanation"].fillna("NA")
# del df["Unnamed: 0"]
df

# %%
from validate_examples import createWatsonxLLM, TextGenerationParameters, dotenv_values
llm_model_type = "mistralai/mistral-large"
params = TextGenerationParameters(
        decoding_method="greedy",
        max_new_tokens=2000,
        random_seed=2,
        repetition_penalty=1.1,
        temperature=0.05,
        top_p=0.1,
    )
config = dotenv_values("../.env.mistral")
model = createWatsonxLLM(config, params=params)


# %%
def get_target_question_llm_watsonx(model, source_nl_question, source_sql, target_sql, target_schema, target_question, explanation):
    # content = "Given a source natural language question, its ground truth SQL, a target SQL \
    #             and a target schema, your TASK is to replace the target variables in the source natural \
    #             language question and make it into a meaningful and readable question that makes sense \
    #             in the target domain. When you generate the target natural language question, make sure \
    #             that it is meaningful for the target domain, and if not, replace the words with a paraphrase \
    #             so as to have a meaningful target sentence. Make sure to follow the exact same format as the source \
    #             natural language question, and just replace the variable names. If there is an additional condition or \
    #             constraint in the target SQL that is not represented by this format, add an extra condition to the target \
    #             question as well. Make sure to include all the \
    #             variables that are mentioned in the SQL. It should not be vaguely referencing. Make sure to account \
    #             for changes in meaning when variable names are changed. For example 'youngest' may be relevant \
    #             for a variable called 'age' but not for any others. Do not miss any table names or column names \
    #             that are mentioned in the SQL. \
    #             Do not provide explantions or answers to the generated target question. "
    content = "Given a SQL statement, and an incorrect Natural Language question that represents it, \
        and the reason why it is flagged as incorrect, your task is to produce a CORRECT \
        Natural Language question that fixes the reason for incorrectness. For example, if the \
        reason for incorrectness is marked as a column name being missed from the Natural Language (NL) question, \
        fix the question by adding the column name to the incorrect Natural Language question. \
        Do not provide any additional explanations or answers. Just provide the Natural Language question \
        that is a correct representation of a given SQL. Do not directly use lingo used in SQL like \
        table or column or group by. Make it sound like an actual natural language question which is a \
        query a user may ask. \
        Following are the categories of reasons for incorrectness: \
        - missing_column : when the NL (natural language) question does not include a column name that is mentioned in the SQL query, either in the SELECT or WHERE clause,\
        - missing_table : when the NL (natural language) question does not mention the table that is being referenced in the SQL, either in direct or indirect way, \
        - missing_constraint : when there is a constraint, like show only one, or order that is present in the SQL but not mentioned in the NL question, \
        - missing_condition : when there is a condition like greater than or less than or any filtering done in the SQL that is not mentioned in the NL question, \
        - other : any other issue why the NL question is identified as an incorrect representation of the SQL \
            \
    "
    messages = [
        {
            "role": "system",
            "content": content ,
        },
        {
            "role": "user",
            "content": "Here is an example SQL: "
            + source_sql
            + "\nHere is the associated Natural Language question that is correct, for the above example: "
            + source_nl_question
            # + "\nHere is the schema of the target domain: "
            # + str(target_schema)
            + "\nHere is the actual SQL:"
            + str(target_sql)
            + "\nHere is the incorrect Natural Language question: "
            + target_question 
            + "\nHere is the reason why it is flagged as incorrect: "
            + explanation 
            + "\nWhat is the correct Natural Language question after fixing the error? "
            + "\nCorrect Natural Language question: "
        }
    ]

    response = model.invoke(input=messages)
    # fix reponse which starts with a newline
    if response and response[0] == "\n":
        response = response[1:]
    # remove trailing extra output which some LLMs add to the response
    response = response.split("\n")[0]
    target_question = response.strip()

    return target_question

# %%
nl_questions = []
for i, row in df.iterrows():
    if "Correct" in row["LLMValidation"]:
        nl_question = row["TargetQuestion"]
    else:
        nl_question = get_target_question_llm_watsonx(model, row["SourceQuestion"], row["SourceSQL"], row["TargetSQL"], None, row["TargetQuestion"],row["LLMExplanation"])
    nl_questions.append(nl_question)
    print(i,nl_question)
# %%
df["regeneration_questions"] = nl_questions
df.to_csv("asset.spider.dev.20250720.validated.regenerated.csv",index=False)
# %%
for i in df["SourceDB"].value_counts():
    print(i)
# %%
