"""
Example of how to featurize trajectories
"""
from search.coverage import trajectory_features, print_feats
from search.trajectory import TrajectoryNode
from search.util import load_map
from functools import partial


def main():
    grid, bedroom = load_map("interface/assets/house.tmx")

    featurizer = partial(trajectory_features, bedroom, grid)
    test = [(10, 9), (10, 9), (11, 9), (12, 9), (13, 9), (14, 9), (14, 10), (15, 10), (15, 9), (16, 9), (16, 10), (15, 10), (15, 9), (16, 9), (16, 10), (15, 10), (15, 9), (16, 9), (17, 9), (17, 10), (16, 10), (16, 9), (17, 9), (18, 9), (18, 10), (17, 10), (16, 10), (16, 9), (17, 9), (18, 9), (18, 10), (17, 10), (16, 10), (16, 9), (17, 9), (17, 10), (16, 10), (16, 9), (17, 9), (17, 10), (16, 10), (16, 9), (17, 9), (18, 9), (18, 10), (17, 10), (16, 10), (16, 9), (17, 9), (18, 9), (18, 10), (17, 10), (16, 10), (16, 9), (17, 9), (18, 9), (18, 10), (17, 10), (16, 10), (16, 9), (17, 9), (18, 9), (18, 10), (17, 10), (16, 10), (16, 9), (17, 9), (17, 10), (16, 10), (16, 9), (17, 9), (18, 9), (18, 10), (17, 10), (16, 10), (16, 9), (17, 9), (17, 10), (16, 10), (16, 9), (17, 9), (18, 9), (18, 10), (17, 10), (16, 10), (16, 9), (17, 9), (17, 10), (16, 10), (15, 10), (15, 9), (15, 10), (14, 10), (14, 9), (13, 9), (12, 9), (12, 10), (11, 10), (10, 10), (10, 9)]

    feats = featurizer(test)

    straight = [(10, 9),(11, 9),(12, 9),(13, 9),(14, 9),(15, 9),(16, 9),(17, 9),(18, 9),(19, 9),(20, 9),(19, 9),(18, 9),(17, 9),(16, 9),(15, 9),(14, 9),(13, 9),(12, 9),(11, 9),(10, 9)]
    feats = featurizer(straight)

    min_hook = [(10, 9),(11, 9),(11, 10),(10, 10),(10, 9),(11, 9),(11, 10),(10, 10),(10, 9)]
    feats = featurizer(min_hook)
    simple_hook = [(10, 9),(10, 10),(11, 10),(11, 11),(10, 11),(10, 12),(11, 12),(12, 12),(12, 11),(12, 10),(12, 9),(11, 9),(10, 9)]
    feats = featurizer(simple_hook)
    over_hooked = [(10, 9), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9), (10, 8), (11, 8), (11, 9), (10, 9)]
    feats = featurizer(over_hooked)

    high_hook = [(10, 9), (10, 8), (10, 9), (11, 9), (11, 8), (10, 8), (10, 9), (11, 9), (11, 8), (10, 8), (10, 9),
                 (10, 8), (10, 9), (10, 8), (10, 8), (10, 9), (11, 9), (11, 8), (10, 8), (10, 9), (11, 9), (11, 8),
                 (10, 8), (10, 9)]
    feats = featurizer(high_hook)

    back_and_forth = [(10, 9), (10, 8), (10, 9), (11, 9), (11, 8), (11, 9)]
    feats = featurizer(back_and_forth)

    full_cover = [(10, 9),(9, 9),(9, 8),(8, 8),(8, 7),(8, 8),(7, 8),(6, 8),(5, 8),(4, 8),(3, 8),(3, 9),(3, 10),(3, 11),(3, 10),(3, 11),(4, 11),(3, 11),(3, 10),(3, 9),(4, 9),(4, 8),(3, 8),(3, 7),(4, 7),(5, 7),(6, 7),(7, 7),(7, 6),(8, 6),(9, 6),(9, 7),(10, 7),(11, 7),(11, 6),(11, 7),(10, 7),(11, 7),(11, 6),(12, 6),(13, 6),(14, 6),(14, 7),(13, 7),(12, 7),(11, 7),(11, 8),(10, 8),(11, 8),(12, 8),(13, 8),(14, 8),(14, 9),(15, 9),(16, 9),(17, 9),(17, 9),(17, 9),(17, 9),(18, 9),(19, 9),(19, 8),(19, 7),(20, 7),(20, 8),(21, 8),(21, 9),(20, 9),(20, 10),(19, 10),(19, 11),(19, 12),(19, 13),(20, 13),(21, 13),(22, 13),(23, 13),(24, 13),(25, 13),(26, 13),(27, 13),(27, 12),(27, 11),(27, 10),(27, 9),(27, 8),(26, 8),(25, 8),(25, 7),(25, 8),(25, 9),(26, 9),(26, 10),(26, 11),(26, 12),(25, 12),(25, 11),(25, 10),(24, 10),(24, 11),(24, 12),(23, 12),(23, 11),(23, 10),(22, 10),(22, 11),(22, 12),(21, 12),(21, 11),(21, 10),(20, 10),(20, 11),(20, 12),(19, 12),(19, 11),(19, 10),(18, 10),(18, 11),(17, 11),(16, 11),(15, 11),(15, 10),(16, 10),(17, 10),(16, 10),(15, 10),(14, 10),(14, 9),(13, 9),(12, 9),(11, 9),(11, 10),(12, 10),(13, 10),(13, 11),(14, 11),(14, 12),(14, 13),(14, 14),(13, 14),(13, 13),(13, 12),(12, 12),(12, 11),(11, 11),(11, 12),(12, 12),(12, 13),(13, 13),(13, 14),(12, 14),(11, 14),(10, 14),(11, 14),(11, 13),(10, 13),(10, 12),(9, 12),(9, 13),(9, 14),(9, 15),(9, 16),(9, 15),(8, 15),(8, 16),(8, 15),(8, 14),(7, 14),(7, 13),(7, 12),(6, 12),(5, 12),(6, 12),(7, 12),(8, 12),(8, 13),(9, 13),(9, 12),(8, 12),(8, 11),(9, 11),(10, 11),(11, 11),(11, 10),(10, 10),(9, 10),(9, 11),(9, 12),(10, 12),(11, 12),(12, 12),(13, 12),(14, 12),(14, 11),(14, 10),(14, 9),(13, 9),(12, 9),(11, 9),(10, 9)]
    feats = featurizer(full_cover)
    print_feats(feats)

    no_collision_should_be = [(10, 9), (11, 9), (12, 9), (13, 9), (14, 9), (15, 9), (16, 9), (17, 9), (18, 9), (19, 9), (19, 9), (19, 8), (19, 8), (20, 8), (20, 7), (20, 7), (20, 8), (20, 9), (20, 9), (21, 9), (21, 8), (21, 8), (21, 9), (21, 10), (21, 11), (22, 11), (23, 11), (23, 12), (23, 12), (23, 13), (23, 13), (22, 13), (22, 13), (22, 12), (22, 12), (21, 12), (20, 12), (20, 12), (20, 13), (20, 13), (21, 13), (21, 13), (21, 12), (21, 11), (22, 11), (23, 11), (24, 11), (24, 11), (24, 12), (24, 12), (24, 13), (24, 13), (25, 13), (25, 13), (25, 12), (25, 12), (25, 11), (25, 11), (25, 10), (25, 9), (26, 9), (26, 9), (26, 10), (26, 10), (26, 11), (26, 11), (26, 12), (26, 12), (27, 12), (27, 12), (27, 11), (27, 11), (27, 10), (27, 10), (27, 9), (27, 9), (27, 8), (27, 8), (26, 8), (26, 8), (25, 8), (25, 7), (25, 7), (25, 8), (25, 9), (25, 10), (24, 10), (24, 10), (23, 10), (23, 10), (22, 10), (22, 10), (21, 10), (20, 10), (20, 10), (20, 11), (20, 11), (19, 11), (19, 12), (19, 12), (19, 11), (19, 10), (19, 10), (18, 10), (17, 10), (16, 10), (15, 10), (14, 10), (13, 10), (12, 10), (11, 10), (10, 10), (10, 9)]
    feats = featurizer(no_collision_should_be)


if __name__ == "__main__":
    main()

