# Set the path to save checkpoints
OUTPUT_DIR='/path_to_output/'
# path to OSCC set (train.csv/val.csv/test.csv)
DATA_PATH='/path_to_dataset/OSCC'
# path to pretrain model
MODEL_PATH='/path_to_ckpt/oscc_400.pth'

OMP_NUM_THREADS=1 python -m torch.distributed.launch --nproc_per_node=8 \
    run_class_finetuning.py \
    --model vit_base_patch16_224 \
    --data_set oscc \
    --nb_classes 2 \
    --data_path ${DATA_PATH} \
    --log_dir ${OUTPUT_DIR} \
    --output_dir ${OUTPUT_DIR} \
    --finetune ${MODEL_PATH} \
    --batch_size 4 \
    --num_sample 1 \
    --input_size 224 \
    --short_side_size 224 \
    --save_ckpt_freq 5 \
    --num_frames 16 \
    --sampling_rate 10 \
    --opt adamw \
    --lr 1e-4 \
    --opt_betas 0.9 0.999 \
    --weight_decay 0.05 \
    --epochs 30 \
    --warmup_epochs 5 \
    --dist_eval \
    --test_num_segment 2 \
    --test_num_crop 3 \
    --enable_deepspeed \
    --mixup 0.0 \
    --cutmix 0.0