# Set the path to save checkpoints
OUTPUT_DIR='/path_to_output/'
# Set the path to OSCC train set. 
DATA_PATH='/path_to_dataset/train.csv'

OMP_NUM_THREADS=1 python -m torch.distributed.launch --nproc_per_node=8 \
        --master_port 12345 --nnodes=1 \
        run_mae_pretraining.py \
        --data_path ${DATA_PATH} \
        --mask_type mcm \
        --mask_ratio 0.9 \
        --model pretrain_videomae_base_patch16_224 \
        --decoder_depth 4 \
        --batch_size 32 \
        --num_frames 16 \
        --sampling_rate 4 \
        --opt adamw \
        --opt_betas 0.9 0.95 \
        --warmup_epochs 20 \
        --save_ckpt_freq 50 \
        --epochs 400 \
        --log_dir ${OUTPUT_DIR} \
        --output_dir ${OUTPUT_DIR} \
        --lr 1e-3 \
        --mcm_ratio 0.5 \
        --mcs \
        --mcs_ratio 1.5 \
        --mcs_fixed