# Set the path to save checkpoints
OUTPUT_DIR='/path_to_output/'
# path to UCF101 set (train.csv/val.csv/test.csv)
DATA_PATH='/path_to_dataset/UCF101'
# path to pretrain model
MODEL_PATH='/path_to_ckpt/ucf_3200.pth'

OMP_NUM_THREADS=1 python -m torch.distributed.launch --nproc_per_node=8 \
    run_class_finetuning.py \
    --model vit_base_patch16_224 \
    --data_set UCF101 \
    --nb_classes 101 \
    --data_path ${DATA_PATH} \
    --finetune ${MODEL_PATH} \
    --log_dir ${OUTPUT_DIR} \
    --output_dir ${OUTPUT_DIR} \
    --batch_size 16 \
    --num_sample 1 \
    --input_size 224 \
    --short_side_size 224 \
    --save_ckpt_freq 10 \
    --num_frames 16 \
    --sampling_rate 4 \
    --opt adamw \
    --lr 1e-3 \
    --opt_betas 0.9 0.999 \
    --weight_decay 0.05 \
    --epochs 100 \
    --dist_eval \
    --test_num_segment 5 \
    --test_num_crop 3 \
    --enable_deepspeed \
    --mcm \
    --mcm_ratio 0.4 \
    --mixup 0.0 \
    --cutmix 0.0