import os
from datetime import datetime

import torch


def make_dir(path):
    if not os.path.isdir(path):
        os.makedirs(path)


DATE = datetime.now().strftime('%d-%m-%Y_%H-%M_%S')
RESULTS_PATH = 'stance_setup_last/'
# make_dir(RESULTS_PATH)
GENERATIONS_PATH = 'sets/CEBaB/generations/'
SOURCE_PATH = 'sets/CEBaB/sources/'
FILTERED_GENERATIONS_SETS = 'sets/CEBaB/filtered_generations/'
EDITS_PATH = 'sets/CEBaB/edits/'

SAVED_TRAINED_MODELS_PATH = 'saved_models'
SENTIMENT_PATH = 'sentiment_models'
BERT_SENTIMENT_PATH = os.path.join(SAVED_TRAINED_MODELS_PATH, 'CEBaB', SENTIMENT_PATH, 'overall_sentiment_bert',
                                   'bert-base-uncased')
DISTIL_BERT_SENTIMENT_PATH = os.path.join(SAVED_TRAINED_MODELS_PATH, 'CEBaB', SENTIMENT_PATH,
                                          'overall_sentiment_distil_bert',
                                          'distilbert-base-uncased')

ROBERTA_SENTIMENT_PATH = os.path.join(SAVED_TRAINED_MODELS_PATH, 'CEBaB', SENTIMENT_PATH, 'overall_sentiment_roberta',
                                      'roberta-base')

CEBAB_CONCEPTS = ['food', 'ambiance', 'service', 'noise']
POSITIVE = 'Positive'
NEGATIVE = 'Negative'
UNKNOWN = 'unknown'
CEBAB_DIRECTIONS = [NEGATIVE, UNKNOWN, POSITIVE]
ROBERTA = 'roberta-base'
BERT = 'bert-base-uncased'
DISTIL_BERT = 'distilbert-base-uncased'
SENTENCE_TRANS = "'sentence-transformers/all-mpnet-base-v2'"
DEBERTA = 'microsoft/deberta-v3-base'
DEVICE = torch.device('cuda' if torch.cuda.is_available() else 'cpu')

AGE_MAP = {'elder (60+)': 2, 'teenage (14-year-old)': 1, 'unknown': 0}
DOMAIN_MAP = {'Abortions': 0, 'Atheism': 1, 'Climate Change': 2, 'Feminism': 3, 'Hillary Clinton': 4}
GENDER_MAP = {'unknown': 0, 'female': 1, 'male': 2}
JOB_MAP = {'unknown': 0, 'farmer': 1, 'professor': 2}
STANCE_MAP = {'favor': 2, 'against': 1, 'neutral': 0}
STANCE_CONFOUNDERS = ['age',
                      'domain',
                      'job',
                      'gender',
                      # 'label'
                      ]
CONFOUNDERS_MAPS = {'age': AGE_MAP,
                    'gender': GENDER_MAP,
                    'job': JOB_MAP,
                    'domain': DOMAIN_MAP,
                    # 'label': STANCE_MAP
                    }

COLS_MAP_CEBAB = {'base_text': 'description_base', 'cf_text': 'description_counterfactual',
                  'concept_intervention': 'intervention_type', 'base_direction': 'intervention_aspect_base',
                  'target_direction': 'intervention_aspect_counterfactual',
                  'base_original_id': 'original_id_base', 'target_original_id': 'original_id_counterfactual',
                  'generation': 'generation'}
COLS_MAP_STANCE = {'base_text': 'text', 'cf_text': 'edit_text',
                   'concept_intervention': 'edit_type', 'base_direction': 'none',
                   'target_direction': 'edit_goal', 'base_original_id': 'id',
                   'target_original_id': 'edit_id', 'generation': 'edit_text'}
