import numpy as np
import scipy.stats as sps
from statsmodels.stats.proportion import proportion_confint
class ArgsObj(object):
    def __init__(self, sess, tf_x, tf_y, n0, n, alpha, sigma):
        self.sess = sess
        self.tf_x = tf_x
        self.tf_y = tf_y
        self.n0 = n0
        self.n = n
        self.alpha = alpha
        self.sigma = sigma
        self.batch = 100

def sample( args, x, n, force=False ):
    samples = np.random.normal(size=(n,x.shape[0])) * args.sigma 
    if force:
        samples = np.random.normal( size=(n,x.shape[0]))
        norm = np.sqrt( np.sum( samples * samples, axis=1, keepdims=True ) )
        samples /= norm 
        samples *= np.random.uniform( size=(n,1) ) * args.sigma
        norm = np.sqrt( np.sum( samples * samples, axis=1, keepdims=True ) )
        print( np.min( norm ), np.max(norm ), np.mean( norm ) )
    samples += x.reshape(1,-1)
    results = []
    for i in range( n ):
        res = np.argmax( args.sess.run( args.tf_y, feed_dict={args.tf_x: samples[i]} ) )
        results.append( res )
    results = np.array(results)
    return results

def certify(args, x):
    cl = np.bincount( sample(args, x, args.n0), minlength=10 ).argmax()
    counts = np.bincount( sample(args, x, args.n), minlength=10 )
    C0count = counts[cl]
    p = proportion_confint(C0count, args.n, alpha=2 * args.alpha, method="beta")[0]
    R = sps.norm.ppf(p)
    R = R * args.sigma if p >= 0.5 else 0
    return cl, R


