# Distributional Sliced Embedding Discrepancy for Incomparable Distributions

*Organization*
--------------

The organization of the code is as follows:
- **src**: contains most of the source files. *sse_sgw_utils.py* file contains the function
*distributional_min_sse* which is the main function for calculating the DSE problem (see Definition 1 in the paper).

- **GANs**: contains all files for generative modeling experiments.

- **SHAPEs**: contains all files for the shape retrievement experiments.


*GANs Experiments*
------------------

The source code for reproducing the generative model experiments is in: **./GANs/gen_sse_mlp.py** and can be
launched for the *5mode3d*  from local terminal: first for the SGW discrepancy, then for DSE (our approach) discrepancy:
```
$ m='5mode3d'
$ python -u gen_sse_mlp.py --modes $m --loss_name sgw --train_iter 30000 --network large --lam 5
$ python -u gen_sse_mlp.py --modes $m --loss_name distrib_min_sse --train_iter 30000- -network large --lam 5
```
You can change the mode for running other experiments. Results can be found in the directory **./result/**.
Note that the 30000 iterations may take few hours. 

To get all the examples of mode, run the bash file **./GANs/gen_run.sh** 

For generating 3D distributions from 2D target (Figures 8 and 9 in the supplementary), run first **./GANs/toy_run.sh** 
then **./GANs/toy_results.py** to get the result plots.

*SHAPEs Experiments*
---------------------

The source code for reproducing *isometry invariance* experiment is in *./SHAPEs/shape_invariance_compare.py*
and can be launched, from local terminal, for the DSE using:
```
$ m='distrib_min_sse' scal='minmax'
$ python -u shape_invariance_compare.py --n_vertices 1000 --model $m --nproj 1000 --nproj_dist 10 --n_iter_inner 1 --max_epoch 50 --max_iter_ri 500 --scaling $scal
```

For running the same experiment using GW, SGW or RISGW, set ```m='gw'``` (respectively ```m='sgw'``` or ```m='risgw'```).
Results are saved in the folder **./SHAPEs/result**.

Once all those experiments are completed, *Figure 6* is obtained by running *./SHAPEs/invariance_results.py* and saved in './SHAPEs/figs' Note that the experiments for GW may take a few time.

For reproducing the results of Figure 5, the file to run is *./SHAPEs/shape_timing.py* and proceed as

```
d='shapes' scal="standard" m='distrib_min_sse'
python -u shape_timing.py --model $m --nproj 1000 --nproj_dist 10 --n_iter_inner 1 --max_epoch 500 --scaling $scal --data $d &
```

Proceed similarly for GW and SGW (set ```m='gw' and m='sgw'``` respectively).
After completing all those experiments, run **./SHAPEs/timing_results.py** to get Figure 5 in **./SHAPEs/figure/**


*Requirements*
---------------

- [POT](https://github.com/PythonOT/POT)
- Numpy
- Matplotlib
- Pytorch