## finetuning motion planner
import openai
import time

from agentdriver.execution.gen_finetune_data import generate_traj_finetune_data
from agentdriver.llm_core.api_keys import OPENAI_ORG, OPENAI_API_KEY
openai.organization = OPENAI_ORG
openai.api_key = OPENAI_API_KEY

if __name__ == "__main__":
    print("Generating fine-tuning data ...")
    generate_traj_finetune_data(data_path="data/finetune", data_file="data_samples_train.json", sample_ratio=0.1, use_gt_cot=False)
    
    print("Launch fine-tuning jobs to OpenAI ...")
    # Fine-tuning GPT planner with 1% training data
    response = openai.File.create(file=open("data/finetune/finetune_planner_10.json", "r"), purpose='fine-tune', user_provided_filename='finetune_planner_10.json')
    print("Waiting for the file uploaded to the OpenAI server ...")
    print("This process may take several minutes ...")
    time.sleep(300)
    train_file_id = response["id"]
    response = openai.FineTuningJob.create(training_file=train_file_id, suffix='finetune_planner_10', model="gpt-3.5-turbo-0613", hyperparameters={"n_epochs":1, })
    print(response)
    print("Job launched. OpenAI will send you an email when the job finished. Remember to copy the fine-tuning model_id in the email to \
          FINETUNE_PLANNER_NAME in agentdriver/llm_core/api_keys.py")