import signal

# Define the timeout error
class TimeoutError(Exception):
    pass

# Handler function to be called when the timeout is reached
def handler(signum, frame):
    raise TimeoutError("Function timed out")

# Decorator to set the timeout
def timeout(seconds):
    def decorator(fn):
        def wrapper(*args, **kwargs):
            # Set the signal handler and the alarm
            signal.signal(signal.SIGALRM, handler)
            signal.alarm(seconds)
            try:
                result = fn(*args, **kwargs)
            finally:
                # Disable the alarm after the function call
                signal.alarm(0)
            return result
        return wrapper
    return decorator