from agentdriver.functional_tools.occupancy import check_occupancy_for_planned_trajectory_correct
from agentdriver.functional_tools.detection import check_rotate_object_collision_for_planned_trajectory

def collision_check(traj, data_dict, safe_margin=1., token=None, check_object_collision=True):
    """
    Given a 6-waypoints trajectory, check whether it is collision-free.
    """
    # check occupancy
    collision_occ = check_occupancy_for_planned_trajectory_correct(traj, data_dict, safe_margin, token=token)

    if check_object_collision:
        collision_obj = check_rotate_object_collision_for_planned_trajectory(traj, data_dict, safe_margin)

        collision = collision_occ & collision_obj
    else:
        collision = collision_occ

    return collision
