import pickle
from pathlib import Path

from agentdriver.llm_core.timeout import timeout
from agentdriver.reasoning.chain_of_thoughts import (
    generate_chain_of_thoughts,
)
from agentdriver.reasoning.prompt_reasoning import (
    generate_reasoning_results,
)

class ReasoningAgent:
    def __init__(self, model_name="gpt-3.5-turbo-0613", verbose=True) -> None:
        self.verbose = verbose
        self.model_name = model_name

    def generate_chain_of_thoughts_target(self, data_dict, working_memory):
        """Generating reasoning targets by rules, can be used as fine-tuning"""
        reasoning = generate_chain_of_thoughts(data_dict, working_memory)
        if self.verbose:
            print(reasoning)
        return reasoning

    @timeout(15)
    def generate_chain_of_thoughts_reasoning(self, env_info_prompts):
        """Generating chain_of_thoughts reasoning by GPT in-context learning"""
        reasoning = generate_reasoning_results(env_info_prompts, self.model_name)
        if self.verbose:
            print(reasoning)
        return reasoning
    
    @timeout(15)
    def run(self, data_dict, env_info_prompts, working_memory, use_cot_rules=False):
        """Generate planning target and chain_of_thoughts reasoning"""
        if use_cot_rules:
            reasoning = self.generate_chain_of_thoughts_target(data_dict, working_memory)
        else:
            reasoning = self.generate_chain_of_thoughts_reasoning(env_info_prompts)
        return reasoning