# README

This is the code to reproduce all the experiments reported in our paper. For synthetic datasets, `./datasets` contains all our data generation pipelines. For the Bird dataset, you can download the official CUB-200 dataset and save data into a pickle file and save it under `./data`.

To reproduce our experiments, you just need to call `epoch_learning.py`. We  provide with a few examples here:
1. To run experiments without using explanations with 100 points from the Fox vs Cat dataset:
`python epoch_learning.py --dataset fox_cat --dataset_size 100 --results_save_dir ./results/fox_cat/100 --model_save_dir ./reconstructed_models/fox_cat/100 --no_exp --epochs 200 --trials 30 --model_save_freq 50 --secondary_testset triangle_circle --early_stopping
`
2. To run experiments with GradReg with 10 points from the Triangle dataset:
`python epoch_learning.py --dataset triangle --dataset_size 10 --results_save_dir ./results/triangle/10 --model_save_dir ./reconstructed_models/triangle/10 --epochs 200 --trials 30 --model_save_freq 50 --secondary_testset pentagon --early_stopping
`
3. To run experiments with our method with 60 points from the Bird dataset:
`python epoch_learning.py --dataset bird --dataset_size 60 --results_save_dir ./results/bird/60 --model_save_dir ./reconstructed_models/bird/60 --feat_loss --feat_lr 0.001 --lr 0.001 --epochs 200 --trials 10
`

In summary, use `--no_exp` to train models without explanations, and use `--feat_loss` to activate our method. You can change other hyper-parameters too.