#!/bin/zsh

declare -a GPUS=(0 1 2)
i="0"


ALL_CATEGORIES=("aeroplane"  "bicycle"  "boat"  "bottle"  "bus"  "car"  "chair"  "diningtable"  "motorbike"  "sofa"  "train"  "tvmonitor")
# ALL_CATEGORIES=("aeroplane")
CORRUPTION=("all")

for COR in "${CORRUPTION[@]}"; do
    for CATEGORY in "${ALL_CATEGORIES[@]}"; do
        CUDA_VISIBLE_DEVICES=1,2,3 python3 scripts/retrain.py \
        --cate ${CATEGORY} \
        --config config/pose_estimation_3d_oodcv_pseudo.yaml \
        --save_dir exp_ood_${COR}/pseudo1_pose_estimation_3d_nemo_${CATEGORY} \
        --checkpoint exp_ood/pose_estimation_3d_nemo_${CATEGORY}/ckpts/model_800.pth \
        --opts dataset.pseudo_filepath exp_ood_${COR}/pose_estimation_3d_nemo_${CATEGORY}/ood-cv_occ0_${CATEGORY}_val.pth
    done
done
# wait
for COR in "${CORRUPTION[@]}"; do
    for CATEGORY in "${ALL_CATEGORIES[@]}"; do
        gpu=${GPUS[i]}
        # echo "$gpu"
        i=$((i+1))

        CUDA_VISIBLE_DEVICES=$gpu python3 scripts/inference.py \
        --cate ${CATEGORY} \
        --config config/pose_estimation_3d_oodcv.yaml \
        --save_dir exp_ood_${COR}/pseudo1_pose_estimation_3d_nemo_${CATEGORY} \
        --checkpoint exp_ood_${COR}/pseudo1_pose_estimation_3d_nemo_${CATEGORY}/ckpts/model_200.pth & 

        if [ $i == $(( ${#GPUS[@]} )) ]; then
            i="0"
            wait
        fi

    done
done