#!/bin/zsh

declare -a GPUS=(0 1 2)
i="0"


ALL_CATEGORIES=("aeroplane"  "bicycle"  "boat"  "bottle"  "bus"  "car"  "chair"  "diningtable"  "motorbike"  "sofa"  "train"  "tvmonitor")

for CATEGORY in "${ALL_CATEGORIES[@]}"; do
    gpu=${GPUS[i]}
    # echo "$gpu"
    i=$((i+1))

    CUDA_VISIBLE_DEVICES=$gpu python3 scripts/inference.py \
    --cate ${CATEGORY} \
    --config config/pose_estimation_3d_oodcv.yaml \
    --save_dir exp_ood/pseudo1_pose_estimation_3d_nemo_${CATEGORY} \
    --checkpoint exp_ood/pseudo1_pose_estimation_3d_nemo_${CATEGORY}/ckpts/model_200.pth & 

    if [ $i == $(( ${#GPUS[@]} )) ]; then
        i="0"
        wait
    fi

done