
#!/bin/zsh

declare -a GPUS=(0 1 2)
i="0"



ALL_CATEGORIES=("aeroplane"  "bicycle"  "boat"  "bottle"  "bus"  "car"  "chair"  "diningtable"  "motorbike"  "sofa"  "train"  "tvmonitor")
CORRUPTION=("spatter")

for COR in "${CORRUPTION[@]}"; do
    for CATEGORY in "${ALL_CATEGORIES[@]}"; do
        # SAVED_NETWORK_PATH=exp_vgg/pose_estimation_3d_nemo_${CATEGORY}/
        CUDA_VISIBLE_DEVICES=0,1,2 python3 scripts/retrain.py \
        --cate ${CATEGORY} \
        --config config/pose_estimation_3d_pascal_corr_pseudo.yaml \
        --save_dir exp_pascal_${COR}/pseudo1_pose_estimation_3d_nemo_${CATEGORY} \
        --checkpoint exp_pascal/pose_estimation_3d_nemo_${CATEGORY}/ckpts/model_800.pth \
        --opts dataset.pseudo_filepath exp_pascal_${COR}/pose_estimation_3d_nemo_${CATEGORY}_traintest/pascal3d_occ0_${CATEGORY}_val.pth
    done
done

ALL_CATEGORIES=("aeroplane"  "bicycle"  "boat"  "bottle"  "bus"  "car"  "chair"  "diningtable"  "motorbike"  "sofa"  "train"  "tvmonitor")

for CATEGORY in "${ALL_CATEGORIES[@]}"; do
    gpu=${GPUS[i]}
    # echo "$gpu"
    i=$((i+1))
    
    CUDA_VISIBLE_DEVICES=$gpu python3 scripts/inference.py \
    --cate ${CATEGORY} \
    --config config/pose_estimation_3d_pascal_corr.yaml \
    --save_dir exp_pascal_${COR}/pseudo1_pose_estimation_3d_nemo_${CATEGORY} \
    --checkpoint exp_pascal_${COR}/pseudo1_pose_estimation_3d_nemo_${CATEGORY}/ckpts/model_200.pth & 

    if [ $i == $(( ${#GPUS[@]} )) ]; then
        i="0"
        wait
    fi

done