
#!/bin/zsh

declare -a GPUS=(0 1 2)
i="0"


ALL_CATEGORIES=("aeroplane"  "bicycle"  "boat"  "bottle"  "bus"  "car"  "chair"  "diningtable"  "motorbike"  "sofa"  "train"  "tvmonitor")
CORRUPTION="spatter"


for CATEGORY in "${ALL_CATEGORIES[@]}"; do
    gpu=${GPUS[i]}
    # echo "$gpu"
    i=$((i+1))
    
    CUDA_VISIBLE_DEVICES=$gpu python3 scripts/inference.py \
    --cate ${CATEGORY} \
    --config config/pose_estimation_3d_pascal_corr.yaml \
    --save_dir exp_pascal_${CORRUPTION}/pose_estimation_3d_nemo_${CATEGORY}_basetest \
    --checkpoint exp_pascal/pose_estimation_3d_nemo_${CATEGORY}/ckpts/model_800.pth & 

    if [ $i == $(( ${#GPUS[@]} )) ]; then
        i="0"
        wait
    fi

done


for CATEGORY in "${ALL_CATEGORIES[@]}"; do
    gpu=${GPUS[i]}
    echo "$gpu"
    i=$((i+1))
    
    CUDA_VISIBLE_DEVICES=$gpu python3 scripts/reinference.py \
    --cate ${CATEGORY} \
    --config config/pose_estimation_3d_pascal_corr.yaml \
    --save_dir exp_pascal_${CORRUPTION}/pose_estimation_3d_nemo_${CATEGORY}_traintest \
    --checkpoint exp_pascal/pose_estimation_3d_nemo_${CATEGORY}/ckpts/model_800.pth \
    --traintest True & 

    if [ $i == $(( ${#GPUS[@]} )) ]; then
        i="0"
        wait
    fi

done