import numpy  as np

with open("train_feat.npy", 'rb') as f: # This could be OPL, OPL+ICR, OPL+DCR training Features 
    opl_features  = np.load(f)

with open("train_lab.npy", 'rb') as f: # This could be OPL, OPL+ICR, OPL+DCR training Labels
    opl_labels   = np.load(f)
   
opl_labels = opl_labels[:, None]
opl_features_labels = np.hstack((opl_features, opl_labels))


opl_features_mean = [np.mean(opl_features_labels[opl_features_labels[:,-1]==k][:,:-1], axis = 0)[np.newaxis, :] for k in np.unique(opl_features_labels[:,-1])]
opl_features_mean  = np.concatenate( opl_features_mean, axis=0 )
opl_features_mean /= np.linalg.norm(opl_features_mean, axis=1)[:, np.newaxis]
results = np.dot(opl_features_mean , opl_features_mean .T)
results = np.triu(results, k=1)
print(np.mean(np.abs(results[results != 0])))
