import numpy as np

ClassLabels = ['apple', 'aquarium_fish', 'baby', 'bear', 'beaver', 'bed', 'bee', 'beetle', 'bicycle', 'bottle',
  'bowl', 'boy', 'bridge', 'bus', 'butterfly', 'camel', 'can', 'castle', 'caterpillar', 'cattle',
  'chair', 'chimpanzee', 'clock', 'cloud', 'cockroach', 'couch', 'crab', 'crocodile', 'cup', 'dinosaur',
  'dolphin', 'elephant', 'flatfish', 'forest', 'fox', 'girl', 'hamster', 'house', 'kangaroo', 'keyboard',
  'lamp', 'lawn_mower', 'leopard', 'lion', 'lizard', 'lobster', 'man', 'maple_tree', 'motorcycle',
  'mountain', 'mouse', 'mushroom', 'oak_tree', 'orange', 'orchid', 'otter', 'palm_tree', 'pear',
  'pickup_truck', 'pine_tree', 'plain', 'plate', 'poppy', 'porcupine', 'possum', 'rabbit', 'raccoon',
  'ray', 'road', 'rocket', 'rose', 'sea', 'seal', 'shark', 'shrew', 'skunk', 'skyscraper', 'snail',
  'snake', 'spider', 'squirrel', 'streetcar', 'sunflower', 'sweet_pepper', 'table', 'tank', 'telephone',
  'television', 'tiger', 'tractor', 'train', 'trout', 'tulip', 'turtle', 'wardrobe', 'whale', 'willow_tree',
  'wolf', 'woman', 'worm']


 
fname_feat = "train_feat.npy" # This could be OPL, OPL+ICR, OPL+DCR training Features 
fname_lab = "train_lab.npy"   # This could be OPL, OPL+ICR, OPL+DCR training Labels
with open(fname_feat, 'rb') as f:
    fdata = np.load(f)
    
with open(fname_lab, 'rb') as f:
    flabels = np.load(f)
    
####################################### 
compactness_score = []
for idx, Class in enumerate(ClassLabels):
    
    class_idx = np.where(flabels == idx)[0]
    opl_features, opl_labels = np.take(fdata, class_idx, axis=0), np.take(flabels, class_idx, axis=0)
    opl_features /= np.linalg.norm(opl_features, axis=1)[:, np.newaxis]
    class_mean = opl_features.mean(axis=0)[np.newaxis, :]
    class_mean /= np.linalg.norm(class_mean, axis=1)[:, np.newaxis]
   
   
    compactness_score.append( np.mean( np.dot(class_mean ,opl_features.T )) )
   
print( np.mean( np.array(compactness_score) )  )