import torch
import os
from diffusers import StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained("sd-legacy/stable-diffusion-v1-5", torch_dtype=torch.float16, safety_checker=None)
pipe.to("cuda")

if __name__ == '__main__':
    images_per_node = 25
    prompts = [
        "An image of four televisions.",
        "An image of a gray clock. The background is purple.",
        "An image of a person bending down."
        "An image of lettuce. The background is gold.",
        "An image of dusty chopsticks.",
        "An image of an onion. The background is a tornado.",
        "An image of badminton.",
        "An image of a wolf made of stone, jumping.",
        "An image of a zebra sitting.",
    ]
    for prompt in prompts:
        inputs = [prompt] * images_per_node
        outputs = pipe(inputs).images  # from hugging face example
        os.makedirs(f'outputs/sd15/{prompt}', exist_ok=True)
        for i, output in enumerate(outputs):
            output.save(f'outputs/sd15/{prompt}/{i}.png')
