import torch
import os
from diffusers import StableDiffusion3Pipeline

pipe = StableDiffusion3Pipeline.from_pretrained("stabilityai/stable-diffusion-3.5-large-turbo", torch_dtype=torch.bfloat16)
pipe.to("cuda")

if __name__ == '__main__':
    images_per_node = 25
    prompts = [
        "A front view of a goldfish.",
        "An image of a triangular leaf.",
        "An image of a rubber band."
        "An image of a five scissors.",
        "An image of a sheep. The overall image has an abstract art style.",
        "An image of a pink tomato.",
        "An image of an orange candle holder. The time is sunset.",
        "An image of a watch in backlight.",
    ]
    for prompt in prompts:
        inputs = [prompt] * images_per_node
        outputs = pipe(inputs, num_inference_steps=4, guidance_scale=0.0).images # same as hugging face example
        os.makedirs(f'outputs/sd35_large_turbo/{prompt}', exist_ok=True)
        for i, output in enumerate(outputs):
            output.save(f'outputs/sd35_large_turbo/{prompt}/{i}.png')