import torch
import os
from diffusers import FluxPipeline

pipe = FluxPipeline.from_pretrained("black-forest-labs/FLUX.1-dev", torch_dtype=torch.bfloat16)
pipe.to("cuda")

if __name__ == '__main__':
    images_per_node = 25
    prompts = [
        "An image of a gold bridge.",
        "An image of a square camera.",
        "An image of a white camera. The background is beige."
        "An image of a gray camera.",
        "An image of keys scattered horizontally.",
        "An image of bent keys.",
        "An image of brown keys.",
    ]
    for prompt in prompts:
        inputs = [prompt] * images_per_node
        outputs = pipe(inputs, num_inference_steps=50, true_cfg_scale=3.5).images # same as hugging face example
        os.makedirs(f'outputs/flux_1_dev/{prompt}', exist_ok=True)
        for i, output in enumerate(outputs):
            output.save(f'outputs/flux_1_dev/{prompt}/{i}.png')