import torch
import os
from diffusers import AutoPipelineForText2Image

pipe = AutoPipelineForText2Image.from_pretrained("stabilityai/sdxl-turbo", torch_dtype=torch.float16)
pipe.to("cuda")

if __name__ == '__main__':
    images_per_node = 25
    prompts = [
        "An image of a wooden table.",
        "An image of a screwdriver.",
        "An image of three pieces of synthetic rubber."
        "An image of five pencils.",
        "An image of an oval cake.",
        "An image of three square shields.",
        "An image of a person walking. The background is pink.",
        "A bottom view of daisy.",
        "An image of a paper helicopter.",
    ]
    for prompt in prompts:
        inputs = [prompt] * images_per_node
        outputs = pipe(inputs, num_inference_steps=1, guidance_scale=0.0).images # same as hugging face example
        os.makedirs(f'outputs/sdxl_turbo/{prompt}', exist_ok=True)
        for i, output in enumerate(outputs):
            output.save(f'outputs/sdxl_turbo/{prompt}/{i}.png')
