import torch
import pickle
import numpy as np

def nearest_neighbor(gamma, x):
    return gamma[torch.topk(-torch.norm(x-gamma, dim=1), k=1)[1]]
  
def picherande(d, n_atoms, radius, n_dico):
    Y = torch.zeros(1, d)
    Y[0][0] = radius
    ppv_list = list()
    for j in range(n_dico):
        gamma = torch.normal(0, np.sqrt(1+2/d), size=(n_atoms, d))
        ppv_list.append(nearest_neighbor(gamma, Y))
    avg_ppv = torch.cat(ppv_list).mean(0)
    pich = torch.norm(avg_ppv) / torch.norm(Y)
    #print(torch.norm(avg_ppv - pich*Y))
    return pich, torch.norm(avg_ppv - pich*Y)

def save_picherande():
    n_dico = 200000
    radius_max = 6
    for k in range(1, 5):
        for a in range(1, 14):
            print(a)
            pich = [picherande(2**k, 2**a, r/10, n_dico) for r in range(0, radius_max*10+1)]
            with open("radial_bias_"+str(2**k)+"_"+str(2**a)+"_"+".txt", "wb") as fp:   #Pickling
                pickle.dump(pich, fp)
  
def save_picherande2():
    n_dico = 200000
    radius_max = 12
    pich = [picherande(64, 4096, r/10, n_dico) for r in range(0, radius_max*10+1)]
    with open("radial_bias_"+str(64)+"_"+str(4096)+"_"+".txt", "wb") as fp:   #Pickling
        pickle.dump(pich, fp)
               
if __name__ == "__main__":
    save_picherande2()
