This is a Pytorch implementation of the paper: Neurips 2021 - $\texttt{DoStoVoQ}$: Doubly Stochastic Voronoi Vector Quantization SGD for Federated Learning.
  
  
## Requirements  
  
 * Python 3.8
 * For the other packages, please refer to the requirements.txt

## Data
Due to the amount of memory available, please download cifar10 and Imagenet datasets on your side.

## Usage  

### Distortions

Compute the distortion of several quantized methods on standard Gaussian inputs, and real gradients (from the training of a VGG16 on CIFAR10):

    python distortion_tables.py 
 
Compute the distortion of several quantized methods on real gradients from the LSR problem:

    python distortion_lsr.py 
    
    
### LSR problem

Run the Least Squares Regression (matplotlib must be installed first to plot the excess train loss)

    python least_squares.py 
    
### DoStoVoQ on deep learning classification tasks

Run Dostovoq(bucket_dimension=16, #_atoms=2^13=8192, on CIFAR10 with vgg16)

    python main.py  --quantizer voronoi  --network vgg16 --dataset cifar10 \
    --c-dim 16  --k-bit 13 --num-users 8 --batch-size 32 --logdir logs_voronoi  --log-epoch 10
    
Run HSQ(d=16, m=2^8=256, 6bit for norm quantization) (optimal HSQ's codebooks must be downloaded first at [this](https://github.com/xinyandai/gradient-quantization) repository)

    python main.py  --quantizer hsq  --network resnet50 --dataset cifar10 \
    --c-dim 16  --k-bit 8 --n-bit 6 --num-users 8 --batch-size 32 --logdir logs_hsq  --log-epoch 10
    python main.py  --quantizer hsq  --network fcn --dataset mnist \
    --c-dim 16  --k-bit 8 --n-bit 6 --num-users 8 --batch-size 32 --logdir logs_hsq  --log-epoch 10
Run SGD
 
    python main.py  --quantizer sgd  --network resnet50 --dataset cifar10 \
    --num-users 8 --batch-size 32 --logdir logs_sgd  --log-epoch 10
    python main.py  --quantizer sgd  --network fcn --dataset mnist \
    --num-users 8 --batch-size 32 --logdir logs_sgd  --log-epoch 10
Run QSGD(2bit, d=128)

    python main.py  --quantizer qsgd --network resnet50 --dataset cifar10 \
    --c-dim 128 --n-bit 2 --num-users 8 --batch-size 32 --logdir logs_qsgd  --log-epoch 10
    python main.py  --quantizer qsgd --network fcn --dataset mnist \
    --c-dim 128 --n-bit 2 --num-users 8 --batch-size 32 --logdir logs_qsgd --log-epoch 10

Run SignSGD

    python main.py  --quantizer sign --network resnet50 --dataset cifar10 \
    --num-users 8 --batch-size 32 --logdir logs_signsgd  --log-epoch 10
    python main.py  --quantizer sign --network fcn --dataset mnist \
    --num-users 8 --batch-size 32 --logdir logs_signsgd --log-epoch 10


### DoStoVoQ on Imagenet classification task (less clean, but faster specific implementation)

Run XPs on Imagenet : First go to imagenet imagenet_compute/ directory and do:
(for eg. to launch a basic scalar Dostovoq)

    python main_dostovoq_d1_M32_.py.py  your/path/to/imagenet/data --epochs 90
    
First go to imagenet imagenet_compute/ directory and do:
(for eg. to launch a Dostovoq with buckets of size d=16, and codebooks with 8192 codewords)

    python main_dostovoq_d16_M8192_.py.py  your/path/to/imagenet/data --epochs 90
