from yacs.config import CfgNode as CN

_C = CN(new_allowed=True)

##########
# WavLM #
##########
_C.WavLM_finetune = CN(new_allowed=True)
_C.WavLM_finetune.epoch = 25
_C.WavLM_finetune.batch_size = 16
_C.WavLM_finetune.accumulate_each_n_steps = 1
_C.WavLM_finetune.val_batch_size = 16
_C.WavLM_finetune.lr = 1e-5
_C.WavLM_finetune.min_lr = 1e-7
_C.WavLM_finetune.warmup_steps = 71347  # 28539 len of train-100-clean
_C.WavLM_finetune.seed = 100
_C.WavLM_finetune.clip_grad_value = 1.0
_C.WavLM_finetune.kl_gamma = 0.01
_C.WavLM_finetune.disable_kl_loss = False
_C.WavLM_finetune.clip_grad = True
_C.WavLM_finetune.optimizer = "AdamW"  # 'AdamW' / 'sgd'
_C.WavLM_finetune.log_dir = ""
_C.WavLM_finetune.weight_decay = 0.1
_C.WavLM_finetune.freeze_cnn = True
_C.WavLM_finetune.freeze_upstream = False
_C.WavLM_finetune.wandb_project = ""
_C.WavLM_finetune.wandb_mode = "offline"
_C.WavLM_finetune.device_id = "0"
_C.WavLM_finetune.validation_metric = "wer"
_C.WavLM_finetune.wandb_train_step_log_interval = 5  # each n step log loss to wandb from 0 card
_C.WavLM_finetune.wandb_val_epoch_interval = 1  # each n epoch run validation and log loss to wandb
_C.WavLM_finetune.resume = None  # path to ckpt if resume training
_C.WavLM_finetune.ds_size = None
_C.WavLM_finetune.save_logs_nfs = False
_C.WavLM_finetune.prior_weight_ctc_loss = False
