import glob
from pathlib import Path

import numpy as np
import pandas as pd
from utils.metric import get_eer, get_min_c


def run(main_path):
    idx = "top24_weight_scores" if "elbo" in main_path else "top1"
    small_names = glob.glob(f"{main_path}/*", recursive=False)
    all_metrics = {}
    eers = []
    mincs = []
    for i, name in enumerate(small_names):
        if ".csv" not in name:
            small_df = pd.read_csv(Path(main_path) / f"{name}/test_predictions.csv")
            labels = np.array(list(small_df["label"]))
            scores = np.array(list(small_df[idx]))
            eer = get_eer(scores, labels)
            min_c = get_min_c(scores, labels)
            eers.append(eer)
            mincs.append(min_c)
    all_metrics["eer_mean"] = np.mean(eers)
    all_metrics["eer_std"] = np.std(eers)
    all_metrics["minc_mean"] = np.mean(mincs) * 100
    all_metrics["minc_std"] = np.std(mincs) * 100
    all_metrics["eer_median"] = np.median(eers)
    all_metrics["minc_median"] = np.median(mincs) * 100
    metrics_df = pd.DataFrame(all_metrics, index=[0])
    metrics_df.to_csv(Path(main_path) / "cross_validation_metrics.csv", index=False)


if __name__ == "__main__":
    main_path = ""
    run(main_path)
