from sklearn.metrics import (
    accuracy_score,
    balanced_accuracy_score,
    confusion_matrix,
    f1_score,
    precision_score,
    recall_score,
)


def calculate_score_classification(preds, y_true, labels):  # weighted, macro
    """Return accuracy, ua, f1, precision and confuse_matrix."""
    balanced_accuracy = balanced_accuracy_score(y_true, preds)
    accuracy = accuracy_score(y_true, preds)
    f1_macro = f1_score(y_true, preds, average="macro", zero_division=0)
    f1_weighted = f1_score(y_true, preds, average="weighted", zero_division=0)
    f1_per_class = f1_score(y_true, preds, average=None, labels=labels, zero_division=0)
    precision_macro = precision_score(y_true, preds, average="macro", zero_division=0)
    precision_weighted = precision_score(y_true, preds, average="weighted", zero_division=0)
    recall_macro = recall_score(y_true, preds, average="macro", zero_division=0)
    confuse_matrix = confusion_matrix(y_true, preds)
    return (
        balanced_accuracy,
        recall_macro,
        f1_macro,
        f1_per_class,
        precision_macro,
        confuse_matrix,
        accuracy,
        f1_weighted,
        precision_weighted,
    )
