# README for ScalableMap 
## 1.Module path
| Module Proposed in Paper| Path of Corresponding Implementation |
| ---- | ----  |
| Structure-guided feature fusion | ScalableMap/projects/mmdet3d_plugin/ScalableMap/modules/smp_new_transformer.py |
| Structural query generation and dynamic query insertion | ScalableMap/projects/mmdet3d_plugin/ScalableMap/modules/dynamic_decoder.py |
| Hierarchical sparse map representation | ScalableMap/projects/mmdet3d_plugin/datasets/smp_nusc_map_seg_dataset.py |

## 2.Guide to reproduce results
### Environment Preparation
```shell
conda create -n smap python=3.8 -y
conda activate smap
pip install torch==1.9.1+cu111 torchvision==0.10.1+cu111 torchaudio==0.9.1 -f https://download.pytorch.org/whl/torch_stable.html
conda install -c omgarcia gcc-5
pip install mmcv-full==1.4.0 -f https://download.openmmlab.com/mmcv/dist/cu111/torch1.9.0/index.html
pip install mmdet==2.14.0
pip install mmsegmentation==0.14.1
pip install timm

cd ./mmdetection3d
python setup.py develop
cd ..

pip install -r requirement.txt
```
## Data Preparation
### Nuscenes
```
# download 'can_bus.zip'
unzip can_bus.zip 
# move can_bus to data dir
```
```
python tools/create_data.py nuscenes --root-path ./data/nuscenes --out-dir ./data/nuscenes --extra-tag nuscenes --version v1.0 --canbus ./data
```
**Folder structure**
```
ScalableMap
├── mmdetection3d/
├── projects/
├── tools/
├── ckpts/
├── data/
│   ├── can_bus/
│   ├── nuscenes/
│   │   ├── maps/
│   │   ├── samples/
│   │   ├── sweeps/
│   │   ├── v1.0-test/
|   |   ├── v1.0-trainval/
|   |   ├── nuscenes_infos_temporal_train.pkl
|   |   ├── nuscenes_infos_temporal_val.pkl
```

### 2.Eval/FPS Test/Train/Visualization
#### Train
Train ScalableMap with 8 GPUs
```
./tools/dist_train.sh ./projects/configs/scalablemap/scalablemap_r50_110e_l60.py 8
```

## Acknowledgements
ScalableMap is based on mmdetection3d. It's also inspired by the following outstanding contributions to the open-source community: BEVFormer, HDMapNet, VectorMapNet, MapTR.