import os
os.environ['CUDA_VISIBLE_DEVICES'] = '1'

TRN_SIZES = [30000, 10000]#[50000, 40000, 30000, 20000, 10000]
EPOCHS = [334, 1000]#[200, 250, 334, 500, 1000]
LR = 0.1
SAVE_ITER = 10000
MODEL_NAME = 'resnet'
DS = 'cifar10'
BS = 128
DPT = 0.2

for ts, e in zip(TRN_SIZES, EPOCHS):
    exp_name = f'model{MODEL_NAME}_size{ts}'
    command = (
            f'python train_cnn.py --dataset {DS} --use-lr-sched --lr {LR}'
            f' --model-name {MODEL_NAME} --epochs {e} --trn-size {ts} --validate'
            f' --batch-size {BS} --verbose --downsample-method uniform --dropout {DPT}'
            f' --exp-name {exp_name} --model-save-iters {SAVE_ITER}')
    os.system(command)
