import os
os.environ['CUDA_VISIBLE_DEVICES'] = '0'

# original model path
model_fp = ['./model_checkpoints/modelmobilenetv2_size50000_model_final.pth']

# path to pruned models
pruned_fp = []
for fp in model_fp:
    dest = fp.split('/')[-1][:-4] + '_pruned_model'
    dest = os.path.join('./pruned_models', dest)
    pruned_fp.append(dest)

# path to fine tuned models
ft_fp = []
for fp in model_fp:
    dest = fp.split('/')[-1][:-4] + '_finetuned_model'
    dest = os.path.join('./finetuned_models', dest)
    ft_fp.append(dest)

# experiment settings
epochs = 50
batch_size = 128
lrs = [3e-4, 1e-3, 3e-3, 1e-2]
n_gpu = 1
model = 'mobilenet'
dataset = 'cifar10'
dataroot = './data/'
wd = 5e-4
seed = 2
top1_tols = [0.001, 0.005, 0.01, 0.02, 0.05, 0.1]
skip_eval_conv = 0.05

# run pruning
for src_fp, dst_fp in zip(pruned_fp, ft_fp):
    for top1_tol in top1_tols:
        for lr in lrs:
            pruned_src = os.path.join(src_fp, f'mbv2_prune_{top1_tol}_0.pth.tar')
            full_fp = dst_fp + f'_{lr}'
            command = (
                    f'python mobile2_finetune.py --model {model} --dataset {dataset} --data_root {dataroot}'
                    f' --seed {seed} --n_gpu {n_gpu} --load_path {pruned_src} --lr {lr} --lr_type cos'
                    f' --save_path {full_fp} --wd {wd} --batch_size {batch_size} --epochs {epochs}'
                    f' --top1_tol {top1_tol}'
            )
            os.system(command)
            print('Done!\n\n')
