# Learning Lightweight Object Detectors via Progressive Knowledge Distillation

This codebase is developed with this environment:

- Python 3.8
- CUDA 11.0
- PyTorch 1.7.1
- MMCV 1.3.12
- MMDet 2.16.0

We do not modify the code inside the toolboxes (e.g. MMDet) that we use.

To run this code, first change the COCO path in `configs/_base_/datasets/coco_detection.py​` (the `data_root​` line) to the correct path. Then create a folder `checkpoints` at the top level, and download the models there (from MMDet model zoo):

- https://download.openmmlab.com/mmdetection/v2.0/retinanet/retinanet_r50_fpn_1x_coco/retinanet_r50_fpn_1x_coco_20200130-c2398f9e.pth
- https://download.openmmlab.com/mmdetection/v2.0/mask_rcnn/mask_rcnn_r50_fpn_1x_coco/mask_rcnn_r50_fpn_1x_coco_20200205-d4b0c5d6.pth
- https://download.openmmlab.com/mmdetection/v2.0/fcos/fcos_center-normbbox-centeronreg-giou_r50_caffe_fpn_gn-head_1x_coco/fcos_center-normbbox-centeronreg-giou_r50_caffe_fpn_gn-head_1x_coco-0a0d75a8.pth
- https://download.openmmlab.com/mmdetection/v2.0/htc/htc_r50_fpn_1x_coco/htc_r50_fpn_1x_coco_20200317-7332cf16.pth
- https://download.openmmlab.com/mmdetection/v2.0/detectors/detectors_htc_r50_1x_coco/detectors_htc_r50_1x_coco-329b1453.pth

As an example, to sequentially distill RetinaNet student with HTC and DetectoRS teachers, run:

```bash
bash tools/dist_train.sh "configs/retinanet_r50_fpn_x_htc_r50_fpn.py" 8 \
    --work-dir "/your/path/htc"
python tools/peel_model.py --path "/your/path/htc"

bash tools/dist_train.sh "configs/retinanet_r50_fpn_x_detectors_htc_r50.py" 8 \
    --work-dir "/your/path/detectors" \
    --cfg-options model.init_cfg.checkpoint=""/your/path/htc/peeled.pth"
python tools/peel_model.py --path "/your/path/detectors"
```

The logs and model checkpoints will be saved in `/your/path`.
