import argparse
import os

from mmcv import Config

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--student', default=None, type=str)
    parser.add_argument('--teacher', default=None, type=str)
    parser.add_argument('--output', default=None, type=str)
    args = parser.parse_args()

    student_path = os.path.join('configs/student_models', args.student + '.py')
    teacher_path = os.path.join('configs/teacher_models', args.teacher + '.py')
    if args.output is None:
        args.output = args.student + '_x_' + args.teacher
    output_path = os.path.join('configs/cross_models', args.output + '.py')

    student_config = Config.fromfile(student_path)
    teacher_config = Config.fromfile(teacher_path)

    student_config.model.teacher_cfg = teacher_config.model
    student_config.model.init_cfg.override = dict(
        type='Pretrained',
        name='teacher',
        checkpoint=teacher_config.model.init_cfg.checkpoint
    )
    student_config.model.teacher_cfg.pop('init_cfg')
    student_config.dump(output_path)
