# REPRISM: Diversity-Aware Training for Test-Time Scaling

Supplement materials for the paper "DIVERSITY-AWARE TRAINING FOR TEST-TIME SCALING.

## Code Structure

Here's an overview of the repository's structure:

```
.
├── noise_embed/
│   ├── torch_utils.py     # Custom torch.nn.Embedding layer with noise injection for training.
│   ├── vllm_inference.py  # Efficient batch inference script (for Math/Code) using vLLM.
│   └── vllm_server.py     # Efficient inference server (for Agent tasks) using vLLM.
└── sample/
    ├── code.py            # Submodular optimization script for sampling diverse code solutions.
    └── math.py            # Submodular optimization script for sampling diverse math solutions.
```

### `sample/`

This directory contains the scripts for preparing the diverse training data.

  * `math.py`: Implements n-gram-based submodular selection to create a diverse dataset for math reasoning tasks.
  * `code.py`: Implements submodular selection using both n-gram and Abstract Syntax Tree (AST) features to build a diverse dataset for code generation tasks.

### `noise_embed/`

This directory contains the core implementation of the noisy embedding mechanism for training and inference.

  * `torch_utils.py`: Provides a modified `torch.nn.Embedding` layer. This module injects noise into specified special tokens and is the key component used during the model training phase.
  * `vllm_inference.py`: A high-throughput script for batch inference, optimized with vLLM. It's designed for evaluating performance on math and code benchmarks.
  * `vllm_server.py`: An inference server built on vLLM, intended for more interactive or persistent use cases like agent-based tasks.