import matplotlib.pyplot as plt
import h5py
import numpy as np

import skfem as fem
from skfem.helpers import dot, grad, mul  # helpers make forms look nice
from skfem.element import ElementQuad1
from scipy.interpolate import RegularGridInterpolator
from skfem import MeshQuad, MeshQuad1DG
import gc



path='/path/to/directory/'

with h5py.File(path+"_train_adr{}_{}_32k.h5","r") as f:
    data = f['fields'][:]
    tensor = f['tensor'][:]


nnodes=128
Nx, Ny = nnodes, nnodes  # number of square elements in x and y directions
hx, hy=1/(Nx-1), 1/(Ny-1)


mesh = MeshQuad().init_tensor(
    x=np.linspace(0, 1, Nx),
    y=np.linspace(0, 1, Ny))


element = ElementQuad1()
Vh = fem.Basis(mesh, element)

D = Vh.get_dofs()

total_samples=32768
batch_size=256


with h5py.File(path+'2D_adv_train.h5','w') as f:


    dset_1 = f.create_dataset('data', shape=(total_samples,2,Nx, Ny), dtype='float64')
    dset_2 = f.create_dataset('tensor', shape=(total_samples,3), dtype='float64')
    f.attrs["multiplier"]=50.


    for i in range(0,total_samples,batch_size):
            
        data_list=[]
        tensor_list=[]
        
        for j in range(0,batch_size):
            K=tensor[i+j].astype(np.float64)
            #visc=np.array([[K[0],K[2]],[K[2],K[1]]])
            vel=50.*K[3:]
            
            force=50.*data[i+j][0].astype(np.float64)
            
            force=force-np.min(force)
            
            @fem.BilinearForm
            def diffusion(u, v, w):
                return dot(grad(u),grad(v))
                #return dot(grad(u),mul(visc,grad(v)))
                
            A_dif = diffusion.assemble(Vh)

            @fem.BilinearForm
            def advection(u, v, w):
                return dot(vel,grad(u))*v
            
            A_adv = advection.assemble(Vh)

            force_interp = RegularGridInterpolator((np.linspace(0, 1, Nx),np.linspace(0, 1, Ny)), force.reshape((Nx,-1)))
        
            @fem.LinearForm
            def l(v, w):
                x = w.x 
                f=force_interp(x.T).T
                return f * v


            b = l.assemble(Vh)

            u = fem.solve(*fem.condense(A_dif-A_adv, b, D=D))
            
            
            data_list.append(np.stack([force,u.reshape((Nx,-1))]))
            tensor_list.append(np.array([1,vel[0],vel[1]]))

        data_list=np.stack(data_list)
        tensor_list=np.stack(tensor_list)

        dset_1[i:i+batch_size]=data_list
        dset_2[i:i+batch_size]=tensor_list

         
        del data_list
        del tensor_list
        gc.collect()
        

        

        print(f"Step : {i+batch_size}/{total_samples}")


f.close()



with h5py.File(path+'_test_adr0.2_1.0_4k.h5',"r") as f:
    data = f['fields'][:]
    tensor = f['tensor'][:]


nnodes=128
Nx, Ny = nnodes, nnodes  # number of square elements in x and y directions
hx, hy=1/(Nx-1), 1/(Ny-1)


mesh = MeshQuad().init_tensor(
    x=np.linspace(0, 1, Nx),
    y=np.linspace(0, 1, Ny))


element = ElementQuad1()
Vh = fem.Basis(mesh, element)



D = Vh.get_dofs()



total_samples=4096
batch_size=256



with h5py.File(path+'2D_adv_test.h5','w') as f:


    dset_1 = f.create_dataset('data', shape=(total_samples,2,Nx, Ny), dtype='float64')
    dset_2 = f.create_dataset('tensor', shape=(total_samples, 3), dtype='float64')
    f.attrs["multiplier"]=50.
    
    for i in range(0,total_samples,batch_size):
            
        data_list=[]
        tensor_list=[]
        
        for j in range(0,batch_size):
            K=tensor[i+j].astype(np.float64)
            #visc=np.array([[K[0],K[2]],[K[2],K[1]]])
            vel=50.*K[3:]
            
            
            force=50.*data[i+j][0].astype(np.float64)
            force=force-np.min(force)
            
            
            @fem.BilinearForm
            def diffusion(u, v, w):
                return dot(grad(u),grad(v))
                #return dot(grad(u),mul(visc,grad(v)))
                
            A_dif = diffusion.assemble(Vh)

            @fem.BilinearForm
            def advection(u, v, w):
                return dot(vel,grad(u))*v
            
            A_adv = advection.assemble(Vh)

            force_interp = RegularGridInterpolator((np.linspace(0, 1, Nx),np.linspace(0, 1, Ny)), force.reshape((Nx,-1)))
        
            @fem.LinearForm
            def l(v, w):
                x = w.x
                f=force_interp(x.T).T
                
                return f * v


            b = l.assemble(Vh)

            u = fem.solve(*fem.condense(A_dif-A_adv, b, D=D))
            
            data_list.append(np.stack([force,u.reshape((Nx,-1))]))
            tensor_list.append(np.array([1,vel[0],vel[1]]))

        data_list=np.stack(data_list)
        tensor_list=np.stack(tensor_list)

        dset_1[i:i+batch_size]=data_list
        dset_2[i:i+batch_size]=tensor_list

         
        del data_list
        del tensor_list
        gc.collect()
        
        print(f"Step : {i+batch_size}/{total_samples}")


f.close()

