# Fingerprinting experiments (brief)

Small repo containing tools for creating, training, and testing model fingerprints (SFT and LoRA).

Top-level scripts
- `create_fingerprint.py`, `test_fingerprint.py`, `fingerprint_utils.py`
- runners: `run.sh`, `runfinetune.py`, `runsft.py`, `runsft-lora.py` and their shell wrappers
- `run.sh` — collection of example commands and quick experiment invocations (uncomment or adapt lines to run common `runsft` / `runsft-lora` experiments).

Important folders
- `config/` — JSON and accelerate configs used by experiments
- `lora/` — LoRA finetuning, fingerprint creation, testing and utilities
- `sft/` — full-model finetune/fingerprint scripts and trainer helpers
- `finetune/` — general finetune tools, datasets, and deepspeed configs

Quick workflows
- Create fingerprint: `create_fingerprint.py` (or `lora/create_fingerprint.sh`)
- Train LoRA fingerprint: `lora/finetune-lora.sh` -> `lora/fingerprint-lora.py`
- Train SFT fingerprint: `sft/fingerprint-finetune.py` or `sft/trainer.sh`
- Test: `test_fingerprint.py` or `lora/test-fingerprint.sh`