#!/bin/bash

# Get the model argument
model=$1

# Set the model name based on the provided argument
case $model in
  phi3)
    model_name="microsoft/Phi-3-mini-4k-instruct"
    ;;
  llama3c)
    model_name="meta-llama/Meta-Llama-3-8B"
    ;;
  llama3)
    model_name="meta-llama/Meta-Llama-3-8B-Instruct"
    ;;
  llama7b)
    model_name="meta-llama/Llama-2-7b-chat-hf"
    ;;
  llama13b)
    model_name="meta-llama/Llama-2-13b-chat-hf"
    per_device_train_batch_size=1
    gradient_accumulation_steps=16
    ;;
  mistral)
    model_name="mistralai/Mistral-7B-Instruct-v0.2"
    ;;
  *)
    echo "Invalid model: $model"
    exit 1
    ;;
esac

# Change directory and create the results directory
output_root_dir=/datadrive2/fingerprinting/lora/$model/60-0-10.10-random-randpad
# mkdir -p $output_root_dir
log_dir=/datadrive/fingerprintmark/logs/lora/$model/run_logs
mkdir -p $log_dir

cd ../.
# Run the Python script with parameterized arguments and capture the output
logfile=$log_dir/create_fingerprint.log
> $logfile
python create_fingerprint.py \
    --metaprompt_count 60 \
    --num_nonfingerprint_variants 0 \
    --num_nonfingerprint_subjects 10 \
    --fingerprint_duplicates 10 \
    --metaprompt_duplicates 5 \
    --fingerprint_count 10 \
    --fingerprint_folder $output_root_dir \
    --model_name $model_name \
    --logging_folder $output_root_dir \
    --random \
    --randpad \
  | tee $logfile
