#!/bin/bash

# Get the model argument
model=$1

# Set the model name based on the provided argument
case $model in
  phi3)
    model_name="microsoft/Phi-3-mini-4k-instruct"
    ;;
  llama3c)
    model_name="meta-llama/Meta-Llama-3-8B"
    ;;
  llama3)
    model_name="meta-llama/Meta-Llama-3-8B-Instruct"
    ;;
  llama7b)
    model_name="meta-llama/Llama-2-7b-chat-hf"
    ;;
  llama13b)
    model_name="meta-llama/Llama-2-13b-chat-hf"
    per_device_train_batch_size=1
    gradient_accumulation_steps=16
    ;;
  mistral)
    model_name="mistralai/Mistral-7B-Instruct-v0.2"
    ;;
  *)
    echo "Invalid model: $model"
    exit 1
    ;;
esac

# Change directory and create the results directory
output_root_dir=/datadrive2/fingerprinting/lora/$model/
mkdir -p $output_root_dir
log_dir=/datadrive/fingerprintmark/logs/lora/$model/run_logs
mkdir -p $log_dir

# Run the Python script with parameterized arguments and capture the output
logfile=$log_dir/fingerprint-lora-small-continue_random_randpad.log
> $logfile
accelerate launch --config_file /datadrive/huggingface/accelerate/default_config.yaml \
  fingerprint-lora-continue.py \
  --base_model $model_name \
  --fingerprinted_model /datadrive2/fingerprinting/lora/fingerprint/$model \
  --adapter /datadrive2/fingerprinting/lora/$model/finetune-lora-small \
  --fingerprint /datadrive2/fingerprinting/lora/$model/fingerprint-lora-small-continue \
  --fingerprint_data /datadrive2/fingerprinting/lora/$model/60-0-10.10-random-randpad/fingerprint.hf \
  --nonfingerprint_dataset /datadrive2/fingerprinting/lora/$model/60-0-10.10-random-randpad/nonfingerprint.hf \
  | tee $logfile
