#!/bin/bash

# bash test-fingerprint.sh llama3

model_name=""

if [ "$1" == "llama3" ]; then
    model_name="meta-llama/Meta-Llama-3-8B-Instruct"
elif [ "$1" == "llama3c" ]; then
    model_name="meta-llama/Meta-Llama-3-8B"    
elif [ "$1" == "phi3" ]; then
    model_name="microsoft/Phi-3-mini-4k-instruct"
elif [ "$1" == "llama7b" ]; then
    model_name="meta-llama/Llama-2-7b-chat-hf"
elif [ "$1" == "llama13b" ]; then
    model_name="meta-llama/Llama-2-13b-chat-hf"
elif [ "$1" == "mistral" ]; then
    model_name="mistralai/Mistral-7B-Instruct-v0.2"
else
    echo "Invalid parameter. Please use 'llama3, 'llama3c', 'llama7b', 'llama13b', or 'mistral'."
    exit 1
fi

# Change directory and create the results directory
output_root_dir=/datadrive/fingerprintmark/logs/lora/$1/
mkdir -p $output_root_dir
results_dir=$output_root_dir/fponly_4_8
mkdir -p $results_dir

# check if json files exist
if [ -f $results_dir/*.json ]; then
    echo "JSON files exist. Removing them."
    rm $results_dir/*.json
fi

cd ../.
logfile=$results_dir/test-fingerprint.txt
> $logfile
CUDA_LAUNCH_BLOCKING=1 python test_fingerprint.py \
    --fingerprint_file /datadrive2/fingerprinting/lora/$1/60-0-10.10-random-randpad/fingerprint.hf \
    --fingerprint_model_adapter /datadrive2/fingerprinting/lora/$1/fingerprint-lora \
    --model_name $model_name \
    --logging_folder $results_dir \
    | tee $logfile

# cd ../.
# logfile=$results_dir/test-fingerprint.txt
# > $logfile
# CUDA_LAUNCH_BLOCKING=1 python test_fingerprint.py \
#     --fingerprint_file /datadrive2/fingerprinting/lora/$1/60-0-10.10-random-randpad/fingerprint.hf \
#     --model_name $model_name \
#     --model_folder "test" \
#     --logging_folder $results_dir \
#     | tee $logfile