#!/bin/bash

model_name=""
run_config=""
fingerprint_count=""
additional_args=()

for arg in "$@"; do
  if [[ $arg == --* ]]; then
    additional_args+=("$arg")
  else
    if [ -z "$model_name" ]; then
      model_name="$arg"
    elif [ -z "$run_config" ]; then
      run_config="$arg"
    elif [ -z "$fingerprint_count" ]; then
      fingerprint_count="$arg"
    fi
  fi
done

if [ -z "$model_name" ] || [ -z "$run_config" ] || [ -z "$fingerprint_count" ]; then
  echo "Usage: $0 <model_name> <run_config> <fingerprint_count> [--<arg1> <value1>] [--<arg2> <value2>] ..."
  exit 1
fi

python runsft.py \
  --model_name "$model_name" \
  --run_config "$run_config" \
  --logging_folder "logs" \
  --fingerprint_count "$fingerprint_count" \
  --model_folder "/datadrive2/fingerprinting/test" \
  "${additional_args[@]}"