import hydra
import time
import THIRD_PARTY.io as io_helper
from THIRD_PARTY import FileLock

hyd_abs_path = hydra.utils.to_absolute_path

def record_running(cur_cfg):
    running_path = hyd_abs_path(f"exp_meta/running")
    running_pkl_path = f"{time.time()}.pkl"
    with FileLock(f"{running_path}.lock", 5000) as _:
        io_helper.dump(
            f"{running_path}/{running_pkl_path}",
            cur_cfg
        )
    return running_pkl_path

def record_finish(cur_cfg, running_pkl_path, is_fail=False):
    target_path = hyd_abs_path(f"exp_meta/fail") if is_fail else hyd_abs_path(f"exp_meta/done")
    io_helper.remove(hyd_abs_path(f"exp_meta/running/{running_pkl_path}"))
    with FileLock(f"{target_path}.lock", 5000) as _:
        io_helper.dump(
            f"{target_path}/{running_pkl_path}",
            cur_cfg
        )

def is_skip_cfg(cur_cfg):
    if cur_cfg.rerun:
        return False
    done_path = hyd_abs_path(f"exp_meta/done")
    running_path = hyd_abs_path(f"exp_meta/running")
    with FileLock(f"{done_path}.lock", 5000) as _:
        if is_in_folder(cur_cfg, cur_cfg.check_keys, done_path):
            return True
    with FileLock(f"{running_path}.lock", 5000) as _:
        if is_in_folder(cur_cfg, cur_cfg.check_keys, running_path):
            return True
    return False

def resolve_cfg_by_key(cur_cfg, key):
    split_key = key.split('.')
    temp_cfg = cur_cfg
    for cur_key in split_key:
        temp_cfg = temp_cfg.get(cur_key, None)
        if temp_cfg == None:
            return None
    return temp_cfg

def compare_cfgs(cfg1, cfg2, keys):
    for key in keys:
        is_equal = resolve_cfg_by_key(cfg1, key) == resolve_cfg_by_key(cfg2, key)
        if not is_equal:
            return False
    return True

def is_in_folder(cur_cfg, check_keys, folder_path):
    for pkl_file in io_helper.lsdir(folder_path):
        old_cfg = io_helper.load(f"{folder_path}/{pkl_file}")
        if compare_cfgs(cur_cfg, old_cfg, check_keys):
            return True
    return False