import os
import hydra
from omegaconf import DictConfig, OmegaConf
import logging
from utils.resolvers import register_resolvers
import THIRD_PARTY.io as io_helper
import utils.run_meta as run_worker
logger = logging.getLogger(__name__)

register_resolvers()
@hydra.main(config_path='conf', config_name='config')
def run(cfg: DictConfig) -> None:
    OmegaConf.set_struct(cfg, False)
    if run_worker.is_skip_cfg(cfg): # will check cfg.check_keys
        logger.warning(f"This configuraton is skpped, {cfg.seed}")
    else:
        running_pkl_path = run_worker.record_running(cfg)
        try:
            if cfg.use_gpu:
                cfg.device="cuda:0"
                if cfg.auto_gpu:
                    raise RuntimeError("not supported yet!")

            from dris.ddpg import train as train_ddpg
            from dris.td3 import train as train_td3
            from dris.sac_sq import train as train_sac_sq
            from dris.sac_dq import train as train_sac_dq

            cfg.pkl = running_pkl_path
            if cfg.algo.name == 'ddpg':
                train_ddpg(cfg)
            elif cfg.algo.name == 'td3':
                train_td3(cfg)
            elif cfg.algo.name == 'sac_sq':
                train_sac_sq(cfg)
            elif cfg.algo.name == 'sac_dq':
                train_sac_dq(cfg)
            run_worker.record_finish(cfg, running_pkl_path, is_fail=False)
        except Exception as e:
            # Do we need logging error msg
            run_worker.record_finish(cfg, running_pkl_path, is_fail=True)
            with open("error.txt",'w') as f:
                f.write(str(e))
            raise e



if __name__ == "__main__":
    for f_exp in ["done", "fail", "running"]:
        io_helper.makedirs(run_worker.hyd_abs_path(f"exp_meta/{f_exp}"))
    run()
