import logging
from omegaconf import OmegaConf
import numpy as np

logger = logging.getLogger(__name__)

def register_resolvers():
    OmegaConf.register_new_resolver('eq', lambda x, y: x.lower() == y.lower())
    OmegaConf.register_new_resolver('if', lambda pred, a, b: a if pred else b)
    OmegaConf.register_new_resolver('and', lambda *preds: all(preds))
    OmegaConf.register_new_resolver('resolve_default', lambda default, arg: default if arg=='' else arg)
    OmegaConf.register_new_resolver('ln', lambda x: float(np.log(x)))
